/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

#ifndef PCI_H_INCLUDED
#define PCI_H_INCLUDED

#include <typedefs.h>
#include "b_io.h"

/* these functions are in pci32.c */

/* --------------------------------------------------------------------------
 * Exported functions 
 * -------------------------------------------------------------------------- */

b_errtype EXPORT BestGenericPCIDWSet(
    b_int32 dwHPSlotId,
    b_int32 Reg_N,
    b_int32 value);

b_errtype EXPORT BestGenericPCIDWGet(
    b_int32 dwHPSlotId,
    b_int32 Reg_N,
    b_int32 * pResult);


/* --------------------------------------------------------------------------
 * Standard I/O functions (see iocommon.c)
 * -------------------------------------------------------------------------- */

b_errtype BestPCISetRegwidth(b_portnumtype OsHandle, int regwidth);
b_errtype BestPCIDeviceConnect(b_portnumtype OsHandle);
b_errtype BestPCICheckConnection(b_portnumtype OsHandle);
void BestPCIReleaseConnection(b_portnumtype OsHandle);
b_errtype BestPciPortTimeoutSet(b_portnumtype OsHandle, 
                                BESTTIMEOUTS * pCallersTimeouts);

/* Default timeouts are defined in b_io.h */

/* --------------------------------------------------------------------------
 * Other exposed functions
 * -------------------------------------------------------------------------- */

b_errtype BestOpenPCI(
    int portnum,
    b_portnumtype * pOsHandle);

b_errtype BestOpenIO(
    int portnum,
    b_portnumtype * pOsHandle);

b_errtype BestClosePCI(
    b_portnumtype OsHandle);

b_errtype BestPCIMailboxWrite(
    b_int32 dwHPSlotId,
    b_int32 value);

b_errtype BestPCIMailboxRead(
    b_int32 dwHPSlotId,
    b_int32 * pResult);

b_errtype BestGetHPSlotIdFromOsHandle(
    b_portnumtype OsHandle,
    b_int32 * pdwHPSlotId);

b_errtype BestPciDevMultiFuncCheck(
    b_int32 dwHPSlotId,
    b_bool * fIsMultiFunc);

struct BEST_SLOT
{
  union
  {
    struct
    {
      unsigned int Function:3;
      unsigned int Slot:5;
      unsigned int BusNumber:8;
    } bits;
    b_int32 Combined;
  } u;
};

typedef struct BEST_SLOT BEST_SLOT;


/* --------------------------------------------------------------------------
 * These declarations are not always used (OS-DEPENDENT)
 * -------------------------------------------------------------------------- */

b_errtype BestPciBasicRead(
    b_handletype handle,
    b_int8ptr pData,
    b_int32 NumBytes,
    b_int32 * NumBytesRead);

b_errtype BestPciBasicWrite(
    b_handletype handle,
    b_int8ptr pData,
    b_int32 NumBytes,
    b_int32 * NumBytesWritten);


#endif
